/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import icyllis.modernui.graphics.MathUtil;
import icyllis.modernui.mc.text.TextLayout;
import icyllis.modernui.mc.text.TextLayoutEngine;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class ModernTextRenderer {
    public static final Vector3f SHADOW_OFFSET = new Vector3f(0.0f, 0.0f, 0.03f);
    public static final Vector3f OUTLINE_OFFSET = new Vector3f(0.0f, 0.0f, 0.01f);
    public static volatile boolean sAllowShadow = true;
    public static volatile float sShadowOffset = 1.0f;
    public static volatile float sOutlineOffset = 0.5f;
    public static volatile boolean sComputeDeviceFontSize = true;
    public static volatile boolean sAllowSDFTextIn2D = true;
    public static volatile boolean sTweakExperienceText = true;
    private final TextLayoutEngine mEngine;

    public ModernTextRenderer(TextLayoutEngine engine) {
        this.mEngine = engine;
    }

    public float drawText(@Nonnull String text, float x, float y, int color, boolean dropShadow, @Nonnull Matrix4f matrix, @Nonnull MultiBufferSource source, Font.DisplayMode displayMode, int colorBackground, int packedLight) {
        if (text.isEmpty()) {
            return x;
        }
        TextLayout layout = this.mEngine.lookupVanillaLayout(text);
        x += this.drawText(layout, x, y, color, dropShadow, matrix, source, displayMode, colorBackground, packedLight);
        return x;
    }

    public float drawText(@Nonnull FormattedText text, float x, float y, int color, boolean dropShadow, @Nonnull Matrix4f matrix, @Nonnull MultiBufferSource source, Font.DisplayMode displayMode, int colorBackground, int packedLight) {
        if (text == CommonComponents.f_237098_ || text == FormattedText.f_130760_) {
            return x;
        }
        TextLayout layout = this.mEngine.lookupFormattedLayout(text);
        x += this.drawText(layout, x, y, color, dropShadow, matrix, source, displayMode, colorBackground, packedLight);
        return x;
    }

    public float drawText(@Nonnull FormattedCharSequence text, float x, float y, int color, boolean dropShadow, @Nonnull Matrix4f matrix, @Nonnull MultiBufferSource source, Font.DisplayMode displayMode, int colorBackground, int packedLight) {
        if (text == FormattedCharSequence.f_13691_) {
            return x;
        }
        TextLayout layout = this.mEngine.lookupFormattedLayout(text);
        x += this.drawText(layout, x, y, color, dropShadow, matrix, source, displayMode, colorBackground, packedLight);
        return x;
    }

    public float drawText(@Nonnull TextLayout layout, float x, float y, int color, boolean dropShadow, @Nonnull Matrix4f matrix, @Nonnull MultiBufferSource source, Font.DisplayMode displayMode, int colorBackground, int packedLight) {
        boolean polygonOffset;
        int a = color >>> 24;
        if (a <= 2) {
            a = 255;
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int mode = this.chooseMode(matrix, displayMode);
        boolean bl = polygonOffset = displayMode == Font.DisplayMode.POLYGON_OFFSET;
        if (layout.hasColorEmoji() && source instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)source).m_109912_(Sheets.m_110787_());
        }
        boolean matrixIsCopied = false;
        float uniformScale = 1.0f;
        if (sComputeDeviceFontSize && (mode == 0 && (matrix.properties() & 8) != 0 || mode == 4)) {
            Matrix4f projection = RenderSystem.getProjectionMatrix();
            if (RenderSystem.getVertexSorting() == VertexSorting.f_276633_ && projection.m23() == 0.0f) {
                float projScaleY;
                Window window = Minecraft.m_91087_().m_91268_();
                float projScaleX = projection.m00() * (float)window.m_85441_() / (2.0f * (float)layout.mCreatedResLevel);
                if (MathUtil.isApproxEqual(projScaleX, projScaleY = Math.abs(projection.m11() * (float)window.m_85442_() / (2.0f * (float)layout.mCreatedResLevel)))) {
                    float upperLimit;
                    matrix = new Matrix4f((Matrix4fc)matrix);
                    matrixIsCopied = true;
                    x += matrix.m30() / matrix.m00();
                    y += matrix.m31() / matrix.m11();
                    matrix.m30(0.0f);
                    matrix.m31(0.0f);
                    uniformScale = matrix.m00() * projScaleX;
                    mode = MathUtil.isApproxEqual(uniformScale, 1.0f) ? 0 : (uniformScale <= (upperLimit = Math.max(1.0f, (float)TextLayoutEngine.sMinPixelDensityForSDF / (float)layout.mCreatedResLevel)) ? 4 : (sAllowSDFTextIn2D ? 1 : 0));
                } else {
                    mode = sAllowSDFTextIn2D ? 1 : 0;
                }
            } else {
                int n = mode = sAllowSDFTextIn2D ? 1 : 0;
            }
        }
        if (dropShadow && sAllowShadow) {
            layout.drawText(matrix, source, x, y, r >> 2, g >> 2, b >> 2, a, true, mode, polygonOffset, uniformScale, colorBackground, packedLight);
            if (!matrixIsCopied) {
                matrix = new Matrix4f((Matrix4fc)matrix);
            }
            matrix.translate((Vector3fc)SHADOW_OFFSET);
        }
        return layout.drawText(matrix, source, x, y, r, g, b, a, false, mode, polygonOffset, uniformScale, colorBackground, packedLight);
    }

    public int chooseMode(Matrix4f ctm, Font.DisplayMode displayMode) {
        if (displayMode == Font.DisplayMode.SEE_THROUGH) {
            return 3;
        }
        if (TextLayoutEngine.sCurrentInWorldRendering) {
            return 1;
        }
        if ((ctm.properties() & 8) == 0) {
            if (sComputeDeviceFontSize && ctm.m23() == 0.0f && MathUtil.isApproxZero(ctm.m01()) && MathUtil.isApproxZero(ctm.m03()) && MathUtil.isApproxZero(ctm.m10()) && MathUtil.isApproxZero(ctm.m13()) && MathUtil.isApproxEqual(ctm.m33(), 1.0f) && MathUtil.isApproxEqual(ctm.m00(), ctm.m11())) {
                return 4;
            }
            if (sAllowSDFTextIn2D) {
                return 1;
            }
        }
        return 0;
    }

    public void drawText8xOutline(@Nonnull FormattedCharSequence text, float x, float y, int color, int outlineColor, @Nonnull Matrix4f matrix, @Nonnull MultiBufferSource source, int packedLight) {
        int a;
        boolean isBlack;
        if (text == FormattedCharSequence.f_13691_) {
            return;
        }
        boolean bl = isBlack = (color & 0xFFFFFF) == 0;
        if (isBlack) {
            color = outlineColor;
        }
        if ((a = color >>> 24) <= 2) {
            a = 255;
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        TextLayout layout = this.mEngine.lookupFormattedLayout(text);
        if (layout.hasColorEmoji() && source instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)source).m_109912_(Sheets.m_110787_());
        }
        layout.drawText(matrix, source, x, y, r, g, b, a, false, 1, false, 1.0f, 0, packedLight);
        if (isBlack || TextLayoutEngine.sCurrentInWorldRendering && !TextLayoutEngine.sUseTextShadersInWorld) {
            return;
        }
        matrix = new Matrix4f((Matrix4fc)matrix);
        a = outlineColor >>> 24;
        if (a <= 2) {
            a = 255;
        }
        r = outlineColor >> 16 & 0xFF;
        g = outlineColor >> 8 & 0xFF;
        b = outlineColor & 0xFF;
        matrix.translate((Vector3fc)OUTLINE_OFFSET);
        layout.drawTextOutline(matrix, source, x, y, r, g, b, a, packedLight);
    }
}

